﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class PowerUpsOnStage1Master : MonoBehaviour {

    public GameObject[] powerUps;
    public Transform spawnPoint;

    private float spawnTime = 520f;
    private float spawnNext = 30f;

    private float timer;

	void Start () {
        timer = Time.time;
	}
	
	void Update () {
        float t = Time.time - timer;
        if (t >= spawnTime) {
            SpawnPowerUps();
            spawnTime = t + spawnNext;
        }
	}

    void SpawnPowerUps() {
        GameObject player = GameObject.Find("Player");
        if (player != null) {
            int rand = Random.Range(0, 3);
            GameObject power = Instantiate(powerUps[rand], spawnPoint.position, spawnPoint.rotation) as GameObject;
            Vector2 direction = player.transform.position - power.transform.position;
            power.GetComponent<CoinScript>().SetCoinDirection(direction);
        }        
    }
}
